document.getElementById("codigo").addEventListener("keyup", getCodigos)

function getCodigos(){
    let inputCP = document.getElementById("codigo").value
    let lista = document.getElementById("lista")

    if (inputCP.length > 0) {
       let url = "getCodigos.php"
       let formData = new FormData()
       formData.append("codigo", inputCP)

       fetch(url, {
          method: "POST",
          body: formData,
          mode: "cors"
       }).then(response => response.json())
       .then(data => {
          lista.style.display = 'block'
          lista.innerHTML = data
       })
       .catch(err => console.log(err))
    } else {
         lista.style.display = 'none'
    }
}

function mostrar(micodigo){
    lista.style.display = 'none'
    document.getElementById("codigo").value = micodigo
}
